select * from kupac 
go

-- problem: brisati podatke u bazi ili ih samo oznaavati kao obrisane, kako bi se zadrala povijest tih podataka

-- dodavanje stupca koji e pokazivati je li neki kupac aktualan ili je izbrisan
alter table Kupac
add
	Deleted bit not null constraint DF_Kupac_Deleted default 0
go

select * from kupac
go

-- kreiranje pogleda koji pokazuje podatke o kupcima i njihovim raunima
create view vKupacRacun
as
	select k.IDKupac, k.Ime, k.Prezime, k.Telefon, r.DatumIzdavanja, r.BrojRacuna
	from kupac as k
	inner join racun as r
	on k.IDKupac=r.KupacID
go

select * from vKupacRacun
go

-- neuspjean pokuaj brisanja kupca i njegovih rauna koritenjem pogleda
delete from vKupacRacun
where IDKupac=378
go

-- kreiranje okidaa koji e umjesto eljenog brisanja kupca samo oznaiti kao izbrisanog
create trigger t_KupacRacun
on vkupacracun
instead of delete
as
 update kupac
 set deleted=1
 where IDKupac in (select idkupac from deleted)
 go

-- pokuaj brisanja kupca koritenjem pogleda
delete from vKupacRacun
where IDKupac in (378, 216)

-- provjera je li brisanje provedeno
select * from vKupacRacun
where IDKupac in (378, 216)

select * from kupac where IDKupac in (378, 216)

alter table Kupac drop constraint DF_Kupac_Deleted
alter table Kupac drop column Deleted
